/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.wuffs.squatgrow.CommonEvents;
import dev.wuffs.squatgrow.config.SquatGrowConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.YamlConfigSerializer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SquatGrow {
    public static final String MOD_ID = "squatgrow";
    private static final Logger LOGGER = LogManager.getLogger();
    public static SquatGrowConfig config;
    public static ConfigHolder<SquatGrowConfig> configHolder;
    public static final Set<TagKey<Block>> tagCache;
    public static final Set<String> wildcardCache;

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void init() {
        configHolder = AutoConfig.register(SquatGrowConfig.class, YamlConfigSerializer::new);
        configHolder.registerLoadListener(SquatGrow::onConfigChanged);
        configHolder.registerSaveListener(SquatGrow::onConfigChanged);
        configHolder.load();
        config = (SquatGrowConfig)configHolder.get();
        TickEvent.PLAYER_POST.register(CommonEvents::onPlayerTick);
        LifecycleEvent.SETUP.register(SquatGrow::onSetup);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new ReloadHandler());
    }

    private static void onSetup() {
        CommonEvents.isMysticalLoaded = Platform.isModLoaded((String)"mysticalagriculture");
    }

    private static InteractionResult onConfigChanged(ConfigHolder<SquatGrowConfig> holder, SquatGrowConfig newConfig) {
        tagCache.clear();
        wildcardCache.clear();
        LOGGER.info("Config loading");
        tagCache.addAll(newConfig.ignoreList.stream().filter(e -> e.contains("#")).map(e -> TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(e.replace("#", "")))).collect(Collectors.toSet()));
        wildcardCache.addAll(newConfig.ignoreList.stream().filter(e -> e.contains("*")).map(e -> e.split(":")[0]).collect(Collectors.toSet()));
        LOGGER.info("Tags: " + tagCache);
        LOGGER.info("Wildcards: " + wildcardCache);
        return InteractionResult.SUCCESS;
    }

    public static Boolean allowTwerk(BlockState state) {
        return SquatGrow.config.useWhitelist == SquatGrow.isBlockInIgnoreList(state);
    }

    private static boolean isBlockInIgnoreList(BlockState state) {
        ResourceLocation resourceLocation = state.m_60734_().arch$registryName();
        if (resourceLocation == null) {
            return false;
        }
        if (SquatGrow.config.ignoreList.contains(resourceLocation.toString()) || wildcardCache.contains(resourceLocation.m_135827_())) {
            return true;
        }
        return tagCache.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0));
    }

    static {
        tagCache = new HashSet<TagKey<Block>>();
        wildcardCache = new HashSet<String>();
    }

    static class ReloadHandler
    implements ResourceManagerReloadListener {
        ReloadHandler() {
        }

        public void m_6213_(ResourceManager manager) {
            configHolder.load();
        }
    }
}

